<?php
include 'database.php';

if (!isset($_SESSION['user_login'])) {
    header("Location: nhan_vien_dang_nhap.php");
    exit();
}

$user_check = mysqli_real_escape_string($con, $_SESSION['user_login']);
$query_role = mysqli_query($con, "SELECT role FROM tb_tai_khoan_dang_nhap WHERE ten_dang_nhap = '$user_check'");
$user_data = mysqli_fetch_assoc($query_role);

if (!$user_data || trim($user_data['role']) !== 'admin') {
    header("Location: nhan_vien_trang_lam_viec.php");
    exit();
}

check_concurrent_session($con);

if (isset($_POST['update_user'])) {
    $old_name = mysqli_real_escape_string($con, $_POST['old_name']);
    $new_name = mysqli_real_escape_string($con, $_POST['new_name']);
    mysqli_query($con, "UPDATE tb_tai_khoan_dang_nhap SET ten_dang_nhap = '$new_name' WHERE ten_dang_nhap = '$old_name'");
}

if (isset($_GET['logout_user'])) {
    $user_out = mysqli_real_escape_string($con, $_GET['logout_user']);
    mysqli_query($con, "UPDATE tb_tai_khoan_dang_nhap SET is_logged_out = 1, last_session_id = '' WHERE ten_dang_nhap = '$user_out'");
    header("Location: admin_quan_ly.php");
    exit();
}

$page_title = "QUẢN TRỊ";
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quản Trị Hệ Thống</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body { margin: 0; background: #f0f2f5; display: flex; justify-content: center; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .admin-wrapper { width: 100%; max-width: 480px; min-height: 100vh; background: #fff; box-shadow: 0 0 20px rgba(0,0,0,0.1); position: relative; }
        .content { padding: 20px; }
        .card { background: #fff; border-radius: 15px; padding: 20px; margin-bottom: 25px; border: 1px solid #f0f0f0; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        h2 { font-size: 16px; color: #1a73e8; border-bottom: 2px solid #1a73e8; padding-bottom: 8px; margin-top: 0; display: flex; align-items: center; gap: 8px; }
        input[type="text"] { width: 100%; padding: 12px; margin: 10px 0; border: 1px solid #ddd; border-radius: 10px; box-sizing: border-box; font-size: 15px; }
        .btn-blue { width: 100%; padding: 14px; border: none; border-radius: 10px; font-weight: bold; cursor: pointer; background: #1a73e8; color: #fff; transition: 0.3s; }
        .btn-blue:active { transform: scale(0.98); }
        .btn-logout-icon { color: #ff4757; font-size: 20px; text-decoration: none; padding: 5px; transition: 0.2s; }
        .btn-logout-icon:hover { color: #ff6b81; }
        .table-container { max-height: 300px; overflow-y: auto; border: 1px solid #eee; border-radius: 8px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { text-align: left; padding: 12px 10px; border-bottom: 1px solid #f5f5f5; font-size: 14px; }
        th { background: #fafafa; position: sticky; top: 0; color: #666; }
        .badge-user { background: #e8f0fe; color: #1967d2; padding: 2px 8px; border-radius: 12px; font-size: 11px; font-weight: bold; }
        ::-webkit-scrollbar { width: 5px; }
        ::-webkit-scrollbar-track { background: #f1f1f1; }
        ::-webkit-scrollbar-thumb { background: #ccc; border-radius: 10px; }
    </style>
</head>
<body>
<div class="admin-wrapper">
    
    <?php include 'layout_header.php'; ?>

    <div class="content">
        <div class="card">
            <h2><i class="fa-solid fa-user-pen"></i> Đổi Tên Tài Khoản</h2>
            <form method="POST">
                <input type="text" name="old_name" placeholder="Tên cũ" required>
                <input type="text" name="new_name" placeholder="Tên mới" required>
                <button type="submit" name="update_user" class="btn btn-blue">CẬP NHẬT</button>
            </form>
        </div>

        <div class="card">
            <h2><i class="fa-solid fa-clock-rotate-left"></i> Lịch Sử Đăng Nhập</h2>
            <div class="table-container">
                <table>
                    <thead><tr><th>User</th><th>Thời gian</th></tr></thead>
                    <tbody>
                        <?php
                        $logs = mysqli_query($con, "SELECT * FROM login_logs ORDER BY id DESC LIMIT 30");
                        while($l = mysqli_fetch_assoc($logs)) {
                            echo "<tr><td>{$l['username']}</td><td><small>{$l['login_time']}</small></td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card">
            <h2><i class="fa-solid fa-users-gear"></i> Quản Lý Phiên</h2>
            <table>
                <thead><tr><th>Tài khoản</th><th style="text-align:right;">Thoát</th></tr></thead>
                <tbody>
                    <?php
                    $users = mysqli_query($con, "SELECT ten_dang_nhap, role FROM tb_tai_khoan_dang_nhap");
                    while($u = mysqli_fetch_assoc($users)) {
                        $is_me = ($u['ten_dang_nhap'] == $_SESSION['user_login']);
                        echo "<tr>
                                <td>
                                    <b>{$u['ten_dang_nhap']}</b> 
                                    <span class='badge-user'>{$u['role']}</span>
                                </td>
                                <td style='text-align:right;'>";
                        if (!$is_me) {
                            echo "<a href='?logout_user=".urlencode($u['ten_dang_nhap'])."' class='btn-logout-icon' title='Đăng xuất máy này'><i class='fa-solid fa-right-from-bracket'></i></a>";
                        } else {
                            echo "<i class='fa-solid fa-circle-check' style='color:#2ed573'></i>";
                        }
                        echo "</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>