<?php
if (!isset($_SESSION['user_login'])) {
    header("Location: nhan_vien_dang_nhap.php");
    exit();
}
check_concurrent_session($con);
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<style>
    .header-nav {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        background: #fff;
        padding: 12px 15px;
        border-bottom: 2px solid #3498db;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
    .menu-icon { font-size: 24px; cursor: pointer; color: #2c3e50; }
    .side-menu {
        position: fixed;
        top: 0;
        left: -280px;
        width: 280px;
        height: 100%;
        background: #2c3e50;
        box-shadow: 4px 0 15px rgba(0,0,0,0.3);
        z-index: 10000;
        transition: 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        padding: 20px;
        box-sizing: border-box;
        overflow-y: auto;
    }
    .side-menu.active { left: 0; }
    .side-menu .menu-label {
        color: #3498db;
        font-size: 11px;
        font-weight: bold;
        text-transform: uppercase;
        margin: 20px 0 10px 10px;
        display: block;
        letter-spacing: 1px;
    }
    .side-menu a {
        display: block;
        color: #ecf0f1;
        text-decoration: none;
        padding: 12px 15px;
        font-size: 15px;
        border-radius: 8px;
        margin-bottom: 5px;
        transition: 0.2s;
    }
    .side-menu a i { width: 25px; font-size: 16px; }
    .side-menu a:hover { background: #34495e; color: #3498db; }
    .overlay-menu {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.6);
        display: none;
        z-index: 9999;
        backdrop-filter: blur(2px);
    }
    .header-title-text {
        text-align: center;
        color: #2c3e50;
        font-size: 18pt;
        font-weight: 800;
        text-transform: uppercase;
        flex-grow: 1;
    }
</style>

<div class="overlay-menu" id="overlayMenu"></div>

<div class="side-menu" id="sideMenuLayout">
    <div style="text-align: center; padding-bottom: 15px; border-bottom: 1px solid #3e5871; margin-bottom: 10px;">
        <span style="color: #fff; font-weight: 800; font-size: 20px;">LINK TK</span>
    </div>

    <span class="menu-label">Chức năng chính</span>
    <a href="nhan_vien_trang_lam_viec.php"><i class="fa-solid fa-house"></i> Trang chủ</a>
    <a href="nhan_vien_nhap_bien_nhan_dat_sanh.php"><i class="fa-solid fa-file-signature"></i> Biên nhận đặt sảnh</a>
    <a href="nhan_vien_nhap_hop_dong_khi_khach_den_chot_mon.php"><i class="fa-solid fa-file-invoice"></i> Hợp đồng chốt món</a>

    <?php if(isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin'): ?>
    <span class="menu-label">Quản trị</span>
    <a href="admin_quan_ly.php"><i class="fa-solid fa-user-shield"></i> Quản lý hệ thống</a>
    <?php endif; ?>

    <span class="menu-label">Tài khoản</span>
    <a href="dang_xuat.php" style="color: #ff4757;"><i class="fa-solid fa-right-from-bracket"></i> Đăng xuất</a>
</div>

<div class="header-nav">
    <div class="menu-icon" onclick="toggleSideMenu()">
        <i class="fa-solid fa-bars"></i>
    </div>
    <div class="header-title-text"><?php echo isset($page_title) ? $page_title : 'TRANG CHỦ'; ?></div>
    <div style="width: 34px;"></div>
</div>

<script>
    function toggleSideMenu() {
        var sideMenu = document.getElementById('sideMenuLayout');
        var overlay = document.getElementById('overlayMenu');
        if (sideMenu.classList.contains('active')) {
            sideMenu.classList.remove('active');
            overlay.style.display = 'none';
        } else {
            sideMenu.classList.add('active');
            overlay.style.display = 'block';
        }
    }
    document.getElementById('overlayMenu').onclick = function() {
        toggleSideMenu();
    };
</script>