<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Đăng Nhập Hệ Thống</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(180deg, #f0f2f5 0%, #e2e8f0 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .login-container {
            width: 100%;
            max-width: 420px;
            background: #ffffff;
            padding: 50px 35px;
            border-radius: 30px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            box-sizing: border-box;
            margin: 15px;
            border: 1px solid rgba(255,255,255,0.8);
        }
        .login-header {
            text-align: center;
            margin-bottom: 45px;
        }
        .login-header i {
            font-size: 60px;
            color: #2196F3;
            margin-bottom: 15px;
            filter: drop-shadow(0 5px 10px rgba(33, 150, 243, 0.3));
        }
        .login-title {
            font-size: 26px;
            font-weight: 800;
            color: #1a202c;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin: 0;
        }
        .form-group {
            margin-bottom: 25px;
            position: relative;
        }
        label {
            display: block;
            margin-bottom: 10px;
            color: #4a5568;
            font-weight: 700;
            font-size: 15px;
            padding-left: 5px;
        }
        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }
        .input-wrapper i {
            position: absolute;
            left: 15px;
            color: #a0aec0;
            font-size: 18px;
            transition: color 0.3s;
        }
        .form-control {
            width: 100%;
            padding: 16px 16px 16px 45px;
            font-size: 16px;
            border: 2px solid #edf2f7;
            border-radius: 15px;
            box-sizing: border-box;
            outline: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: #f8fafc;
            color: #2d3748;
        }
        .form-control:focus {
            border-color: #2196F3;
            background: #ffffff;
            box-shadow: 0 10px 20px rgba(33, 150, 243, 0.1);
        }
        .form-control:focus + i {
            color: #2196F3;
        }
        .btn-submit {
            width: 100%;
            padding: 18px;
            font-size: 20px;
            font-weight: 800;
            color: #ffffff;
            background: linear-gradient(135deg, #2196F3 0%, #1976D2 100%);
            border: none;
            border-radius: 15px;
            cursor: pointer;
            box-shadow: 0 8px 20px rgba(33, 150, 243, 0.4);
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-top: 15px;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 25px rgba(33, 150, 243, 0.5);
        }
        .btn-submit:active {
            transform: translateY(0);
            box-shadow: 0 4px 10px rgba(33, 150, 243, 0.4);
        }
    </style>
</head>
<body>

    <div class="login-container">
        <div class="login-header">
            <i class="fa-solid fa-circle-user"></i>
            <h1 class="login-title">Link TK</h1>
        </div>
        
        <form action="nhan_vien_xl_dang_nhap.php" method="POST">
            <div class="form-group">
                <label>Tên đăng nhập</label>
                <div class="input-wrapper">
                    <input type="text" name="ten_dang_nhap" class="form-control" placeholder="Nhập tên tài khoản..." required autocomplete="off">
                    <i class="fa-solid fa-user"></i>
                </div>
            </div>

            <div class="form-group">
                <label>Mật khẩu</label>
                <div class="input-wrapper">
                    <input type="password" name="mat_khau" class="form-control" placeholder="Nhập mật khẩu..." required>
                    <i class="fa-solid fa-lock"></i>
                </div>
            </div>

            <button type="submit" name="nut_dang_nhap" class="btn-submit">
                Đăng nhập <i class="fa-solid fa-right-to-bracket" style="margin-left: 8px;"></i>
            </button>
        </form>
    </div>

</body>
</html>