<?php
include 'database.php';
$page_title = "NHẬP HỢP ĐỒNG TIỆC";

if (!isset($_SESSION['user_login'])) {
    header("Location: nhan_vien_dang_nhap.php");
    exit();
}
check_concurrent_session($con);
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Hợp Đồng Tiệc</title>
    <script src='jquery-3.2.1.min.js' type='text/javascript'></script>
    <script src='select2/dist/js/select2.min.js' type='text/javascript'></script>
    <link href='select2/dist/css/select2.min.css' rel='stylesheet' type='text/css'>
    <style>
        body { margin: 0; padding: 0; background-color: #ecf0f1; display: flex; justify-content: center; font-family: 'Segoe UI', Arial, sans-serif; }
        .mobile-wrapper { width: 100%; max-width: 480px; min-height: 100vh; background-color: #f4f7f6; box-shadow: 0 0 20px rgba(0,0,0,0.1); position: relative; padding-bottom: 40px; }
        .content-container { padding: 20px; }
        .card-section { background: #ffffff; border-radius: 15px; padding: 20px; margin-bottom: 25px; box-shadow: 0 10px 20px rgba(0,0,0,0.05); border: 1px solid #ffffff; }
        .section-label { font-size: 13pt; color: #34495e; margin-bottom: 15px; display: block; font-weight: 600; border-left: 4px solid #3498db; padding-left: 10px; }
        label { display: block; font-weight: bold; margin-top: 15px; font-size: 10pt; color: #555; }
        input[type="text"], select { width: 100%; padding: 12px; margin-top: 8px; border: 1.5px solid #edf2f7; border-radius: 10px; box-sizing: border-box; font-size: 11pt; outline: none; background: #f8fafc; transition: 0.3s; }
        input[type="text"]:focus, select:focus { border-color: #3498db; background: #fff; box-shadow: 0 0 0 4px rgba(52,152,219,0.1); }
        .flex-row { display: flex; gap: 10px; align-items: center; }
        .flex-item { flex: 1; }
        .inline-row { display: flex; align-items: center; justify-content: space-between; gap: 10px; margin-top: 10px; }
        .inline-row span { font-weight: bold; color: #555; font-size: 10pt; white-space: nowrap; }
        .inline-row select, .inline-row input { margin-top: 0; flex-grow: 1; }
        .drink-item { background: #f8fafc; padding: 15px; border-radius: 12px; margin-bottom: 15px; border: 1px solid #edf2f7; }
        .drink-name-row { display: flex; align-items: center; gap: 10px; margin-bottom: 10px; }
        .drink-name-row span { font-weight: bold; color: #2c3e50; font-size: 11pt; white-space: nowrap; }
        .btn { width: 100%; padding: 18px; border-radius: 12px; font-weight: bold; font-size: 13pt; cursor: pointer; border: none; margin-bottom: 15px; text-transform: uppercase; letter-spacing: 1px; }
        .btn-print-main { background: linear-gradient(135deg, #2e7d32 0%, #388e3c 100%); color: white; }
        .btn-print-sub { background: linear-gradient(135deg, #1565c0 0%, #1976d2 100%); color: white; }
        .checkbox-item { display: flex; align-items: center; gap: 10px; margin-top: 15px; background: #f0f7ff; padding: 12px; border-radius: 10px; }
    </style>
</head>
<body>

<div class="mobile-wrapper">
    <?php include 'layout_header.php'; ?>

    <div class="content-container">
        <form method="get">
            
            <div class="card-section">
                <span class="section-label">Thông tin cố định</span>
                <label>MÃ TIỆC</label>
                <input type="text" name="ma_tiec_full" value="<?php echo $ma_tiec_can_xuat_thong_tin; ?>">
                
                <div class="inline-row">
                    <span>Sảnh:</span>
                    <select name="sanh">
                        <option value="VS1" <?php if($sanh == 'VS1') echo 'selected'; ?>>VS1</option>
                        <option value="VS2" <?php if($sanh == 'VS2') echo 'selected'; ?>>VS2</option>
                        <option value="Nhà Khách" <?php if($sanh == 'Nhà Khách') echo 'selected'; ?>>Nhà Khách</option>
                    </select>
                </div>
                
                <div class="inline-row">
                    <span>Giờ:</span>
                    <input type="text" name="gio" value="<?php echo $gio; ?>" class="flex-item">
                    <span>Thứ:</span>
                    <select name="thu" class="flex-item">
                        <option value="Hai" <?php if($thu == 'Hai') echo 'selected'; ?>>Hai</option>
                        <option value="Ba" <?php if($thu == 'Ba') echo 'selected'; ?>>Ba</option>
                        <option value="Tư" <?php if($thu == 'Tư') echo 'selected'; ?>>Tư</option>
                        <option value="Năm" <?php if($thu == 'Năm') echo 'selected'; ?>>Năm</option>
                        <option value="Sáu" <?php if($thu == 'Sáu') echo 'selected'; ?>>Sáu</option>
                        <option value="Bảy" <?php if($thu == 'Bảy') echo 'selected'; ?>>Bảy</option>
                        <option value="Chủ Nhật" <?php if($thu == 'Chủ Nhật') echo 'selected'; ?>>Chủ Nhật</option>
                    </select>
                </div>

                <div style="margin-top: 15px; padding-top: 15px; border-top: 1px solid #eee;">
                    <label>📅 Dương lịch (dd/mm/yy)</label>
                    <div class="flex-row">
                        <input type="text" name="ngay_duong" value="<?php echo $ngay_duong; ?>" placeholder="dd" class="flex-item">
                        <input type="text" name="thang_duong" value="<?php echo $thang_duong; ?>" placeholder="mm" class="flex-item">
                        <input type="text" name="nam_duong" value="<?php echo $nam_duong; ?>" placeholder="yy" class="flex-item">
                    </div>

                    <label>🌙 Âm lịch (dd/mm/yy)</label>
                    <div class="flex-row">
                        <input type="text" name="ngay_am" value="<?php echo $ngay_am; ?>" placeholder="dd" class="flex-item">
                        <input type="text" name="thang_am" value="<?php echo $thang_am; ?>" placeholder="mm" class="flex-item">
                        <input type="text" name="nam_am" value="<?php echo $nam_am; ?>" placeholder="yy" class="flex-item">
                    </div>
                </div>
            </div>

            <div class="card-section">
                <span class="section-label">Thông tin chỉnh sửa</span>
                <label>Người làm hợp đồng</label>
                <select name="nguoi_tiep_khach">
                    <option value="Nguyễn Văn A">Nguyễn Văn A</option>
                    <option value="Nguyễn Văn B">Nguyễn Văn B</option>
                </select>

                <div class="inline-row">
                    <span>Loại Lễ:</span>
                    <select name="event">
                        <option value="<?php echo $event; ?>" selected><?php echo $event; ?></option>
                        <option value="Lễ Thành Hôn">Lễ Thành Hôn</option>
                        <option value="Lễ Tân Hôn">Lễ Tân Hôn</option>
                        <option value="Lễ Vu Quy">Lễ Vu Quy</option>
                    </select>
                </div>

                <label>Tên CD-CR</label>
                <input type="text" name="ten_cd_cr" value="<?php echo $ten_cd_cr; ?>">

                <div class="flex-row">
                    <div class="flex-item"><label>Đại diện</label><input type="text" name="nguoi_dai_dien"></div>
                    <div class="flex-item"><label>Điện thoại</label><input type="text" name="sdt" value="<?php echo $sdt; ?>"></div>
                </div>

                <label>CCCD</label>
                <input type="text" name="cccd" placeholder="Số CCCD">

                <label>Địa chỉ</label>
                <input type="text" name="dia_chi" value="<?php echo $dia_chi; ?>">

                <div class="flex-row">
                    <div class="flex-item"><label>Số bàn</label><input type="text" name="so_ban" value="<?php echo $so_ban; ?>"></div>
                    <div class="flex-item"><label>Bàn dự phòng</label><input type="text" name="so_ban_du_phong"></div>
                </div>
                
                <label>Suất ăn (k)</label>
                <input type="text" name="suat_an" value="<?php if ($suat_an > 0) echo $suat_an/1000; ?>">

                <div class="checkbox-item">
                    <input type="checkbox" id="ban_ho" name="ban_ho_co_hoac_khong" value="1" <?php if ($ban_ho_co_hoac_khong == 1) echo "checked"; ?>>
                    <label for="ban_ho" style="margin-top:0">Bàn họ</label>
                </div>

                <div class="flex-row">
                    <div class="flex-item"><label>Số bàn chay</label><input type="text" name="so_ban_chay"></div>
                    <div class="flex-item"><label>Đơn giá chay</label><input type="text" name="don_gia_ban_chay"></div>
                </div>

                <label>Đặt cọc lần 1 / Lần 2 (VNĐ)</label>
                <div class="flex-row">
                    <input type="text" name="dat_coc_lan_1" id="number_dat_coc_lan_1" value="<?php echo number_format($dat_coc_lan_1); ?>" class="flex-item">
                    <input type="text" name="dat_coc_lan_2" id="number_dat_coc_lan_2" value="<?php echo number_format($dat_coc_lan_2); ?>" class="flex-item">
                </div>
            </div>

            <div class="card-section">
                <span class="section-label">Thực đơn (10 món)</span>
                <?php for ($i = 1; $i <= 10; $i++) { $current_ma_mon = ${"ma_mon_$i"}; ?>
                <div style="margin-bottom: 12px; display: flex; align-items: center; gap: 10px;">
                    <span style="font-weight: bold; color: #3498db; min-width: 20px;"><?php echo $i; ?>.</span>
                    <select name="ma_mon_<?php echo $i; ?>" id="selUser_<?php echo $i; ?>">
                        <option value="<?php echo $current_ma_mon; ?>"><?php echo $current_ma_mon; ?></option>
                    </select>
                </div>
                <script>$(document).ready(function(){ $("#selUser_<?php echo $i; ?>").select2({width:'100%'}); });</script>
                <?php } ?>
            </div>

            <div class="card-section">
                <span class="section-label">Thức uống</span>

                <div class="drink-item">
                    <div class="drink-name-row">
                        <span>1. Tên Bia:</span>
                        <select name="ten_loai_bia_select" onchange="checkOther(this, 'ten_loai_bia_custom')">
                            <option value="Tiger">Tiger</option>
                            <option value="Ken Bạc">Ken Bạc</option>
                            <option value="other">Loại khác...</option>
                        </select>
                    </div>
                    <input type="text" name="ten_loai_bia_custom" id="ten_loai_bia_custom" placeholder="Tên bia khác..." style="display:none; margin-bottom:8px;">
                    <div class="flex-row">
                        <div class="flex-item"><label>Đơn giá</label><input type="text" name="don_gia_bia" class="number-format"></div>
                        <div class="flex-item"><label>Dự phòng sảnh</label><input type="text" name="so_luong_bia_du_phong"></div>
                        <div class="flex-item"><label>Dự phòng bếp</label><input type="text" name="bia_dp_bep"></div>
                    </div>
                </div>

                <?php 
                $ngot = ['2a' => 'ten_loai_nuoc_ngot_01', '2b' => 'ten_loai_nuoc_ngot_02', '2c' => 'ten_loai_nuoc_ngot_03', '2d' => 'ten_loai_nuoc_ngot_04'];
                foreach($ngot as $key => $var) { 
                ?>
                <div class="drink-item">
                    <div class="drink-name-row">
                        <span><?php echo $key; ?>. Nước ngọt:</span>
                        <select name="<?php echo $var; ?>_select" onchange="checkOther(this, '<?php echo $var; ?>_custom')">
                            <option value="Pepsi">Pepsi</option>
                            <option value="7Up">7Up</option>
                            <option value="other">Loại khác...</option>
                        </select>
                    </div>
                    <input type="text" name="<?php echo $var; ?>_custom" id="<?php echo $var; ?>_custom" placeholder="Tên khác..." style="display:none; margin-bottom:8px;">
                    <div class="flex-row">
                        <div class="flex-item"><label>Đơn giá</label><input type="text" name="don_gia_ngot_<?php echo $key; ?>" class="number-format"></div>
                        <div class="flex-item"><label>Mỗi bàn (Lon)</label><input type="text" name="moi_ban_<?php echo $key; ?>"></div>
                    </div>
                    <div class="flex-row">
                        <div class="flex-item"><label>Dự phòng sảnh</label><input type="text" name="s_<?php echo $key; ?>"></div>
                        <div class="flex-item"><label>Dự phòng bếp</label><input type="text" name="b_<?php echo $key; ?>"></div>
                    </div>
                </div>
                <?php } ?>

                <div class="drink-item">
                    <div class="drink-name-row">
                        <span>3. Nước suối (Aquafina)</span>
                    </div>
                    <div class="flex-row">
                        <div class="flex-item"><label>Đơn giá</label><input type="text" name="don_gia_nuoc_suoi" value="<?php echo $don_gia_nuoc_suoi; ?>" class="number-format"></div>
                        <div class="flex-item"><label>Mỗi bàn (Chai)</label><input type="text" name="suoi_moi_ban" value="4"></div>
                    </div>
                    <div class="flex-row">
                        <div class="flex-item"><label>Dự phòng sảnh</label><input type="text" name="suoi_dp_sanh" value="2"></div>
                        <div class="flex-item"><label>Dự phòng bếp</label><input type="text" name="suoi_dp_bep" value="0"></div>
                    </div>
                </div>
            </div>

            <div class="card-section">
                <span class="section-label">Dịch vụ & Ghi chú</span>
                <div class="inline-row">
                    <span>Phí dịch vụ:</span>
                    <input type="text" name="phi_dich_vu" id="number_phi_dich_vu" value="<?php echo number_format($phi_dich_vu); ?>" class="number-format">
                </div>
                <label>Dịch vụ đặt thêm</label>
                <input type="text" name="dich_vu_dat_them" value="<?php echo $dich_vu_dat_them; ?>">
                <label>Ghi chú</label>
                <input type="text" name="ghi_chu" value="<?php echo $ghi_chu; ?>">
                <div class="checkbox-item">
                    <input type="checkbox" id="hinh_anh" name="cho_phep_su_dung_hinh_anh" value="1" <?php if ($cho_phep_su_dung_hinh_anh == 1) echo "checked"; ?>>
                    <label for="hinh_anh" style="margin-top:0">Sử dụng hình ảnh</label>
                </div>
            </div>

            <div class="btn-group">
                <button type="submit" class="btn btn-print-main" formaction="nhan_vien_CAP_NHAT_hop_dong_tiec_va_in_hop_dong_tiec.php">IN HỢP ĐỒNG</button>
                <button type="submit" class="btn btn-print-sub" formaction="nhan_vien_in_phu_luc_va_thanh_ly.php">IN PHỤ LỤC & THANH LÝ</button>
            </div>
        </form>
    </div>
</div>

<script>
    function checkOther(select, customId) {
        var customInput = document.getElementById(customId);
        customInput.style.display = (select.value === 'other') ? 'block' : 'none';
    }
    document.querySelectorAll('.number-format').forEach(input => {
        input.addEventListener('input', function(e) {
            let v = e.target.value.replace(/,/g, '');
            if (!isNaN(v) && v !== '') e.target.value = Number(v).toLocaleString('en-US');
        });
    });
</script>
</body>
</html>