<?php
include 'database.php';

if (!isset($_SESSION['user_login'])) {
    header("Location: nhan_vien_dang_nhap.php");
    exit();
}

check_concurrent_session($con);

$res_tiec = mysqli_query($con, "SELECT ma_tiec FROM tb_tiec ORDER BY id DESC LIMIT 1");
$row_tiec = mysqli_fetch_assoc($res_tiec);
$ma_tiec_hien_thi = $row_tiec ? $row_tiec['ma_tiec'] : "CHƯA CÓ DỮ LIỆU TIỆC";

$page_title = "TRANG CHỦ";
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Trang Chủ Làm Việc</title>
    <script src='jquery-3.2.1.min.js' type='text/javascript'></script>
    <script src='select2/dist/js/select2.min.js' type='text/javascript'></script>
    <link href='select2/dist/css/select2.min.css' rel='stylesheet' type='text/css'>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #ecf0f1;
            display: flex;
            justify-content: center;
            font-family: 'Segoe UI', Arial, sans-serif;
        }
        .mobile-wrapper {
            width: 100%;
            max-width: 480px;
            min-height: 100vh;
            background-color: #f4f7f6;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            position: relative;
            padding-bottom: 40px;
        }
        .content-container {
            padding: 20px;
        }
        .card-section {
            background: #ffffff;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: 0 10px 20px rgba(0,0,0,0.05);
            border: 1px solid #ffffff;
        }
        .section-label {
            font-size: 13pt;
            color: #34495e;
            margin-bottom: 15px;
            display: block;
            font-weight: 600;
            border-left: 4px solid #3498db;
            padding-left: 10px;
        }
        .btn {
            width: 100%;
            display: block;
            padding: 16px;
            margin-bottom: 15px;
            border-radius: 12px;
            font-weight: bold;
            cursor: pointer;
            text-align: center;
            border: none;
            color: white;
            transition: transform 0.2s, box-shadow 0.2s;
            position: relative;
            overflow: hidden;
            text-decoration: none;
        }
        .btn:active {
            transform: scale(0.98);
        }
        .btn-blue {
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            box-shadow: 0 6px 15px rgba(52, 152, 219, 0.3);
            font-size: 18pt;
        }
        .btn-orange {
            background: linear-gradient(135deg, #e67e22 0%, #d35400 100%);
            box-shadow: 0 6px 15px rgba(230, 126, 34, 0.3);
            font-size: 16pt;
        }
        .info-box {
            background-color: #e3f2fd;
            color: #1565c0;
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 10px;
            border: 1px dashed #1976d2;
        }
        .radio-item {
            display: flex;
            align-items: center;
            background: #fafafa;
            padding: 15px;
            border: 1px solid #eee;
            border-radius: 10px;
            margin-bottom: 10px;
            transition: 0.2s;
        }
        .radio-item:hover {
            background: #f0f8ff;
            border-color: #3498db;
        }
        .radio-item input {
            width: 24px;
            height: 24px;
            margin-right: 15px;
            accent-color: #3498db;
        }
        .radio-item label {
            font-size: 14pt;
            color: #2c3e50;
            font-weight: 500;
            word-break: break-all;
            cursor: pointer;
        }
        .divider {
            height: 2px;
            background-color: #eee;
            margin: 20px 0;
            border-radius: 2px;
        }
    </style>
</head>
<body>

<div class="mobile-wrapper">
    
    <?php include 'layout_header.php'; ?>

    <div class="content-container">
        <form method="get">
            
            <div class="card-section">
                <span class="section-label">Khách đặt sảnh (Chưa chốt món)</span>
                <input type="submit" value="BIÊN NHẬN ĐẶT SẢNH" formaction="nhan_vien_nhap_bien_nhan_dat_sanh.php" class="btn btn-blue">
            </div>

            <div class="card-section">
                <div class="info-box">
                    <b>MÃ TIỆC MỚI NHẤT</b><br>
                    <small>(Dữ liệu lấy từ hệ thống)</small>
                </div>
                
                <div class="radio-item">
                    <input type="radio" name="radio_tiec_gan_nhat" id="mt_recent" value="<?php echo $ma_tiec_hien_thi; ?>" checked>
                    <label for="mt_recent"><?php echo $ma_tiec_hien_thi; ?></label>
                </div>
            </div>

            <div class="card-section">
                <span class="section-label">Thao tác & Khách chốt món</span>
                
                <input type="submit" value="In lại biên nhận" formaction="in_lai_bien_nhan_dat_sanh.php" class="btn btn-orange">
                
                <div class="divider"></div>

                <input type="submit" value="HỢP ĐỒNG (CHỐT MÓN)" formaction="nhan_vien_nhap_hop_dong_khi_khach_den_chot_mon.php" class="btn btn-orange">
            </div>

            <div class="card-section">
                <span class="section-label">Xuất dữ liệu & Báo cáo</span>
                
                <input type="submit" value="Menu (Đơn giản)" formaction="xuat_thuc_don_dang_don_gian_de_in_menu.php" class="btn btn-blue">
                
                <input type="submit" value="Xuất thực đơn" formaction="xuat_thuc_don.php" class="btn btn-orange">
                
                <input type="submit" value="Xuất tờ dàn dĩa" formaction="xuat_to_giay_dan_dia.php" class="btn btn-orange">
            </div>

        </form>
    </div>
</div>

</body>
</html>