<?php
include 'database.php';
$page_title = "ĐỔI MẬT KHẨU";

if (!isset($_SESSION['user_login'])) {
    header("Location: nhan_vien_dang_nhap.php");
    exit();
}
check_concurrent_session($con);

$message = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_SESSION['user_login'];
    $old_pass = $_POST['old_pass'];
    $new_pass = $_POST['new_pass'];
    $confirm_pass = $_POST['confirm_pass'];

    $username = mysqli_real_escape_string($con, $username);
    $old_pass = mysqli_real_escape_string($con, $old_pass);
    $new_pass = mysqli_real_escape_string($con, $new_pass);

    if ($new_pass !== $confirm_pass) {
        $message = "<div class='alert error'>Mật khẩu mới không trùng khớp!</div>";
    } else {
        $check_sql = "SELECT mat_khau FROM tb_tai_khoan_dang_nhap WHERE ten_dang_nhap = '$username'";
        $result = mysqli_query($con, $check_sql);
        
        if (mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $db_pass = $row['mat_khau'];
            
            if ($db_pass === $old_pass) {
                $update_sql = "UPDATE tb_tai_khoan_dang_nhap SET mat_khau = '$new_pass' WHERE ten_dang_nhap = '$username'";
                
                if (mysqli_query($con, $update_sql)) {
                    $message = "<div class='alert success'>Đổi mật khẩu thành công!</div>";
                } else {
                    $message = "<div class='alert error'>Lỗi hệ thống!</div>";
                }
            } else {
                $message = "<div class='alert error'>Mật khẩu cũ không đúng!</div>";
            }
        } else {
            $message = "<div class='alert error'>Tài khoản không tồn tại!</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Đổi Mật Khẩu</title>
    <style>
        body { margin: 0; padding: 0; background-color: #ecf0f1; display: flex; justify-content: center; font-family: 'Segoe UI', Arial, sans-serif; }
        .mobile-wrapper { width: 100%; max-width: 480px; min-height: 100vh; background-color: #f4f7f6; box-shadow: 0 0 20px rgba(0,0,0,0.1); position: relative; padding-bottom: 40px; }
        .content-container { padding: 20px; }
        .card-section { background: #ffffff; border-radius: 15px; padding: 25px 20px; margin-bottom: 25px; box-shadow: 0 10px 20px rgba(0,0,0,0.05); border: 1px solid #ffffff; }
        .section-label { font-size: 13pt; color: #34495e; margin-bottom: 20px; display: block; font-weight: 600; text-align: center; }
        label { display: block; font-weight: bold; margin-top: 15px; font-size: 10pt; color: #555; }
        .password-wrapper { position: relative; margin-top: 8px; }
        input[type="password"], input[type="text"] { width: 100%; padding: 14px; padding-right: 45px; border: 1.5px solid #edf2f7; border-radius: 10px; box-sizing: border-box; font-size: 12pt; outline: none; background: #f8fafc; transition: 0.3s; }
        input:focus { border-color: #3498db; background: #fff; box-shadow: 0 0 0 4px rgba(52,152,219,0.1); }
        .toggle-icon { position: absolute; right: 15px; top: 50%; transform: translateY(-50%); cursor: pointer; color: #95a5a6; font-size: 18px; }
        .btn-submit { width: 100%; padding: 16px; border-radius: 12px; font-weight: bold; font-size: 13pt; cursor: pointer; border: none; background: linear-gradient(135deg, #3498db 0%, #2980b9 100%); color: white; box-shadow: 0 6px 15px rgba(52,152,219,0.3); margin-top: 25px; text-transform: uppercase; letter-spacing: 1px; }
        .alert { padding: 12px; border-radius: 8px; margin-bottom: 15px; text-align: center; font-weight: bold; font-size: 14px; }
        .alert.error { background: #fee2e2; color: #dc2626; border: 1px solid #fecaca; }
        .alert.success { background: #dcfce7; color: #16a34a; border: 1px solid #bbf7d0; }
    </style>
</head>
<body>

<div class="mobile-wrapper">
    <?php include 'layout_header.php'; ?>

    <div class="content-container">
        <?php echo $message; ?>

        <form method="post">
            <div class="card-section">
                <span class="section-label">THAY ĐỔI MẬT KHẨU</span>
                
                <label>Mật khẩu cũ</label>
                <div class="password-wrapper">
                    <input type="password" name="old_pass" id="old_pass" required>
                    <i class="fa-solid fa-eye toggle-icon" onclick="togglePass('old_pass', this)"></i>
                </div>

                <label>Mật khẩu mới</label>
                <div class="password-wrapper">
                    <input type="password" name="new_pass" id="new_pass" required>
                    <i class="fa-solid fa-eye toggle-icon" onclick="togglePass('new_pass', this)"></i>
                </div>

                <label>Xác nhận mật khẩu mới</label>
                <div class="password-wrapper">
                    <input type="password" name="confirm_pass" id="confirm_pass" required>
                    <i class="fa-solid fa-eye toggle-icon" onclick="togglePass('confirm_pass', this)"></i>
                </div>

                <button type="submit" class="btn-submit">CẬP NHẬT</button>
            </div>
        </form>
    </div>
</div>

<script>
    function togglePass(inputId, icon) {
        var input = document.getElementById(inputId);
        if (input.type === "password") {
            input.type = "text";
            icon.classList.remove("fa-eye");
            icon.classList.add("fa-eye-slash");
        } else {
            input.type = "password";
            icon.classList.remove("fa-eye-slash");
            icon.classList.add("fa-eye");
        }
    }
</script>

</body>
</html>