<?php
include 'database.php';
$page_title = "BIÊN NHẬN ĐẶT SẢNH";

if (!isset($_SESSION['user_login'])) {
    header("Location: nhan_vien_dang_nhap.php");
    exit();
}
check_concurrent_session($con);
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Biên nhận đặt sảnh</title>
    <style>
        body { margin: 0; padding: 0; background-color: #ecf0f1; display: flex; justify-content: center; font-family: 'Segoe UI', Arial, sans-serif; }
        .mobile-wrapper { width: 100%; max-width: 480px; min-height: 100vh; background-color: #f4f7f6; box-shadow: 0 0 20px rgba(0,0,0,0.1); position: relative; padding-bottom: 40px; }
        .content-container { padding: 20px; }
        .card-section { background: #ffffff; border-radius: 15px; padding: 20px; margin-bottom: 25px; box-shadow: 0 10px 20px rgba(0,0,0,0.05); border: 1px solid #ffffff; }
        .section-label { font-size: 13pt; color: #34495e; margin-bottom: 15px; display: block; font-weight: 600; border-left: 4px solid #27ae60; padding-left: 10px; }
        label { display: block; font-weight: bold; margin-top: 15px; font-size: 11pt; color: #555; }
        input[type="text"], select { width: 100%; padding: 14px; margin-top: 8px; border: 1.5px solid #edf2f7; border-radius: 10px; box-sizing: border-box; font-size: 12pt; outline: none; background: #f8fafc; transition: 0.3s; }
        input[type="text"]:focus, select:focus { border-color: #27ae60; background: #fff; box-shadow: 0 0 0 4px rgba(39,174,96,0.1); }
        .flex-row { display: flex; gap: 12px; }
        .flex-item { flex: 1; }
        .btn-submit { width: 100%; padding: 18px; border-radius: 12px; font-weight: bold; font-size: 14pt; cursor: pointer; border: none; background: linear-gradient(135deg, #27ae60 0%, #219150 100%); color: white; box-shadow: 0 6px 15px rgba(39,174,96,0.3); margin-top: 10px; text-transform: uppercase; letter-spacing: 1px; }
        .blue-box { background: #ebf8ff; padding: 15px; border-radius: 12px; margin-top: 15px; border: 1px solid #bee3f8; }
        .checkbox-group { display: flex; align-items: center; gap: 12px; margin-top: 15px; background: #fff5f5; padding: 12px; border-radius: 10px; border: 1px solid #fed7d7; }
        input[type="checkbox"] { width: 22px; height: 22px; accent-color: #e53e3e; }
        .highlight-red { color: #e53e3e; font-weight: 800; font-size: 10pt; }
    </style>
</head>
<body>

<div class="mobile-wrapper">
    <?php include 'layout_header.php'; ?>

    <div class="content-container">
        <form action="nhan_vien_in_bien_nhan_dat_sanh.php" method="get">
            
            <div class="card-section">
                <span class="section-label">Thông tin nhân viên & Lễ</span>
                
                <label>Người làm hợp đồng</label>
                <select name="nguoi_tiep_khach">
                    <option value="MAI QUỐC DUY">MAI QUỐC DUY</option>
                    <option value="Nguyễn Văn A">Nguyễn Văn A</option>
                    <option value="Nguyễn Văn B">Nguyễn Văn B</option>
                </select>

                <label>Loại Lễ</label>
                <select name="event">
                    <option value="Lễ Tân Hôn">Lễ Tân Hôn</option>
                    <option value="Lễ Thành Hôn">Lễ Thành Hôn</option>
                    <option value="Lễ Vu Quy">Lễ Vu Quy</option>
                    <option value="Lễ Báo Hỷ">Lễ Báo Hỷ</option>
                    <option value="Tiệc Sinh Nhật">Tiệc Sinh Nhật</option>
                    <option value="Tiệc Tất Niên">Tiệc Tất Niên</option>
                </select>
            </div>

            <div class="card-section">
                <span class="section-label">Thông tin khách hàng</span>
                
                <label>Tên CD-CR</label>
                <input type="text" name="ten_cd_cr" placeholder="Nhập tên cô dâu - chú rể...">

                <div class="flex-row">
                    <div class="flex-item">
                        <label>Người đại diện</label>
                        <input type="text" name="dai_dien" placeholder="Tên người đại diện">
                    </div>
                    <div class="flex-item">
                        <label>Điện thoại</label>
                        <input type="text" name="sdt" placeholder="Số điện thoại">
                    </div>
                </div>

                <label>Địa chỉ</label>
                <input type="text" name="dia_chi" placeholder="Nhập địa chỉ chi tiết...">

                <div class="flex-row">
                    <div class="flex-item">
                        <label>Số bàn dự kiến</label>
                        <input type="text" name="so_ban" placeholder="Số bàn">
                    </div>
                    <div class="flex-item">
                        <label>Giá suất ăn (VNĐ)</label>
                        <input type="text" name="suat_an" id="number_suat_an" placeholder="320,000">
                    </div>
                </div>
            </div>

            <div class="card-section">
                <span class="section-label">Thời gian & Địa điểm</span>
                
                <label>Sảnh tiệc</label>
                <select name="sanh">
                    <option value="VS1">VS1</option>
                    <option value="VS2">VS2</option>
                    <option value="Nhà khách">Nhà khách</option>
                </select>

                <div class="flex-row">
                    <div class="flex-item">
                        <label>Giờ đãi (h00')</label>
                        <input type="text" name="gio" placeholder="11h00">
                    </div>
                    <div class="flex-item">
                        <label>Thứ</label>
                        <select name="thu">
                            <option value="Hai">Hai</option>
                            <option value="Ba">Ba</option>
                            <option value="Tư">Tư</option>
                            <option value="Năm">Năm</option>
                            <option value="Sáu">Sáu</option>
                            <option value="Bảy">Bảy</option>
                            <option value="Chủ Nhật">Chủ Nhật</option>
                        </select>
                    </div>
                </div>

                <div class="blue-box">
                    <label style="margin-top:0">Dương lịch</label>
                    <div class="flex-row">
                        <input type="text" name="ngay_duong" placeholder="Ngày" class="flex-item">
                        <input type="text" name="thang_duong" placeholder="Tháng" class="flex-item">
                        <input type="text" name="nam_duong" value="<?php echo date("Y"); ?>" class="flex-item">
                    </div>

                    <label>Âm lịch</label>
                    <div class="flex-row">
                        <input type="text" name="ngay_am" placeholder="Ngày" class="flex-item">
                        <input type="text" name="thang_am" placeholder="Tháng" class="flex-item">
                        <input type="text" name="nam_am" value="<?php echo date("Y"); ?>" class="flex-item">
                    </div>

                    <div class="checkbox-group">
                        <input type="checkbox" id="nhuan" name="thang_nhuan_dung_ON_sai_null">
                        <label for="nhuan" class="highlight-red" style="margin-top:0">CÓ THÁNG NHUẬN</label>
                    </div>
                </div>
            </div>

            <div class="card-section">
                <span class="section-label">Chi phí & Ghi chú</span>
                
                <div class="flex-row">
                    <div class="flex-item">
                        <label>Tiền cọc 1 (VNĐ)</label>
                        <input type="text" name="dat_coc_lan_1" id="number_dat_coc_lan_1" placeholder="0">
                    </div>
                    <div class="flex-item">
                        <label>Phí dịch vụ (VNĐ)</label>
                        <input type="text" name="phi_dich_vu" id="number_phi_dich_vu" placeholder="0">
                    </div>
                </div>

                <label>Ghi chú</label>
                <input type="text" name="ghi_chu" placeholder="Yêu cầu thêm...">
            </div>

            <input type="submit" value="IN BIÊN NHẬN ĐẶT SẢNH" class="btn-submit">

        </form>
    </div>
</div>

<script>
    const ids = ['number_dat_coc_lan_1', 'number_phi_dich_vu', 'number_suat_an'];
    ids.forEach(id => {
        const el = document.getElementById(id);
        if(el) {
            el.addEventListener('input', function(e) {
                let value = e.target.value.replace(/,/g, '');
                if (!isNaN(value) && value !== '') {
                    e.target.value = Number(value).toLocaleString('en-US');
                } else {
                    e.target.value = '';
                }
            });
        }
    });
</script>

</body>
</html>